# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 3
# Experiment: DAxDA, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR3_strategy.txt
# LLM Suggested Fallback: D

def peaceful_butterfly(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize harmony index to track opponent's cooperation
    harmony_index = sum(1 for move in opp_history if move == "C") - 2 * sum(1 for move in opp_history if move == "D")
    
    # Early rounds: build trust with cooperation
    if len(my_history) < 2:
        return "C"
    
    # If opponent defected even once, switch to defection
    if "D" in opp_history:
        return "D"
    
    # Middle rounds: alternate between C and D to confuse
    if len(my_history) < 5:
        return "D" if len(my_history) % 2 == 0 else "C"
    
    # Late rounds: escalate defection if opponent is still cooperative
    if harmony_index > 0:
        return "D" if len(my_history) % 3 != 0 else "C"
    else:
        return "D"